/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.StatementTreeObject;
import java.io.Serializable;
import java.util.ArrayList;

public final class ConstraintDef
implements Serializable,
StatementTreeObject,
Cloneable {
    static final long serialVersionUID = -6648793780645431100L;
    public static final int PRIMARY_KEY = 1;
    public static final int UNIQUE = 2;
    public static final int FOREIGN_KEY = 3;
    public static final int CHECK = 4;
    int type;
    String name;
    Expression check_expression;
    Expression original_check_expression;
    ArrayList column_list;
    ArrayList column_list2;
    String reference_table_name;
    String update_rule;
    String delete_rule;
    short deferred = (short)6;

    public void setName(String name) {
        this.name = name;
    }

    public void setPrimaryKey(ArrayList list) {
        this.type = 1;
        this.column_list = list;
    }

    public void setUnique(ArrayList list) {
        this.type = 2;
        this.column_list = list;
    }

    public void setCheck(Expression exp) {
        this.type = 4;
        this.check_expression = exp;
        try {
            this.original_check_expression = (Expression)exp.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.getMessage());
        }
    }

    public void setForeignKey(String ref_table, ArrayList col_list, ArrayList ref_col_list, String delete_rule, String update_rule) {
        this.type = 3;
        this.reference_table_name = ref_table;
        this.column_list = col_list;
        this.column_list2 = ref_col_list;
        this.delete_rule = delete_rule;
        this.update_rule = update_rule;
    }

    public void setInitiallyDeferred() {
        this.deferred = (short)5;
    }

    public void setNotDeferrable() {
        this.deferred = (short)7;
    }

    public String[] getColumnList() {
        return this.column_list.toArray(new String[this.column_list.size()]);
    }

    public String[] getColumnList2() {
        return this.column_list2.toArray(new String[this.column_list2.size()]);
    }

    public String getDeleteRule() {
        return this.delete_rule;
    }

    public String getUpdateRule() {
        return this.update_rule;
    }

    public void prepareExpressions(ExpressionPreparer preparer) throws DatabaseException {
        if (this.check_expression != null) {
            this.check_expression.prepare(preparer);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ConstraintDef v = (ConstraintDef)super.clone();
        if (this.check_expression != null) {
            v.check_expression = (Expression)this.check_expression.clone();
        }
        if (this.column_list != null) {
            v.column_list = (ArrayList)this.column_list.clone();
        }
        if (this.column_list2 != null) {
            v.column_list2 = (ArrayList)this.column_list2.clone();
        }
        return v;
    }
}

